// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// The SpatialSpec.
/// </summary>
public partial class SpatialSpec : ProvisionableConstruct
{
    /// <summary>
    /// The path for which the indexing behavior applies to. Index paths
    /// typically start with root and end with wildcard (/path/*).
    /// </summary>
    public BicepValue<string> Path 
    {
        get { Initialize(); return _path!; }
        set { Initialize(); _path!.Assign(value); }
    }
    private BicepValue<string>? _path;

    /// <summary>
    /// List of path&apos;s spatial type.
    /// </summary>
    public BicepList<CosmosDBSpatialType> Types 
    {
        get { Initialize(); return _types!; }
        set { Initialize(); _types!.Assign(value); }
    }
    private BicepList<CosmosDBSpatialType>? _types;

    /// <summary>
    /// Creates a new SpatialSpec.
    /// </summary>
    public SpatialSpec()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SpatialSpec.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _path = DefineProperty<string>("Path", ["path"]);
        _types = DefineListProperty<CosmosDBSpatialType>("Types", ["types"]);
    }
}
