// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Cosmos DB SQL container resource object.
/// </summary>
public partial class RestorableSqlContainerPropertiesResourceContainer : CosmosDBSqlContainerResourceInfo
{
    /// <summary>
    /// A system generated property that specifies the addressable path of the
    /// container resource.
    /// </summary>
    public BicepValue<string> Self 
    {
        get { Initialize(); return _self!; }
    }
    private BicepValue<string>? _self;

    /// <summary>
    /// A system generated property. A unique identifier.
    /// </summary>
    public BicepValue<string> Rid 
    {
        get { Initialize(); return _rid!; }
    }
    private BicepValue<string>? _rid;

    /// <summary>
    /// A system generated property that denotes the last updated timestamp of
    /// the resource.
    /// </summary>
    public BicepValue<float> Timestamp 
    {
        get { Initialize(); return _timestamp!; }
    }
    private BicepValue<float>? _timestamp;

    /// <summary>
    /// A system generated property representing the resource etag required for
    /// optimistic concurrency control.
    /// </summary>
    public BicepValue<ETag> ETag 
    {
        get { Initialize(); return _eTag!; }
    }
    private BicepValue<ETag>? _eTag;

    /// <summary>
    /// Creates a new RestorableSqlContainerPropertiesResourceContainer.
    /// </summary>
    public RestorableSqlContainerPropertiesResourceContainer() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// RestorableSqlContainerPropertiesResourceContainer.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _self = DefineProperty<string>("Self", ["_self"], isOutput: true);
        _rid = DefineProperty<string>("Rid", ["_rid"], isOutput: true);
        _timestamp = DefineProperty<float>("Timestamp", ["_ts"], isOutput: true);
        _eTag = DefineProperty<ETag>("ETag", ["_etag"], isOutput: true);
    }
}
