// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Parameters to indicate the information about the restore.
/// </summary>
public partial class ResourceRestoreParameters : ProvisionableConstruct
{
    /// <summary>
    /// The id of the restorable database account from which the restore has to
    /// be initiated. For example:
    /// /subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}.
    /// </summary>
    public BicepValue<string> RestoreSource 
    {
        get { Initialize(); return _restoreSource!; }
        set { Initialize(); _restoreSource!.Assign(value); }
    }
    private BicepValue<string>? _restoreSource;

    /// <summary>
    /// Time to which the account has to be restored (ISO-8601 format).
    /// </summary>
    public BicepValue<DateTimeOffset> RestoreTimestampInUtc 
    {
        get { Initialize(); return _restoreTimestampInUtc!; }
        set { Initialize(); _restoreTimestampInUtc!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _restoreTimestampInUtc;

    /// <summary>
    /// Specifies whether the restored account will have Time-To-Live disabled
    /// upon the successful restore.
    /// </summary>
    public BicepValue<bool> IsRestoreWithTtlDisabled 
    {
        get { Initialize(); return _isRestoreWithTtlDisabled!; }
        set { Initialize(); _isRestoreWithTtlDisabled!.Assign(value); }
    }
    private BicepValue<bool>? _isRestoreWithTtlDisabled;

    /// <summary>
    /// Creates a new ResourceRestoreParameters.
    /// </summary>
    public ResourceRestoreParameters()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ResourceRestoreParameters.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _restoreSource = DefineProperty<string>("RestoreSource", ["restoreSource"]);
        _restoreTimestampInUtc = DefineProperty<DateTimeOffset>("RestoreTimestampInUtc", ["restoreTimestampInUtc"]);
        _isRestoreWithTtlDisabled = DefineProperty<bool>("IsRestoreWithTtlDisabled", ["restoreWithTtlDisabled"]);
    }
}
