// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Configuration values for periodic mode backup.
/// </summary>
public partial class PeriodicModeProperties : ProvisionableConstruct
{
    /// <summary>
    /// An integer representing the interval in minutes between two backups.
    /// </summary>
    public BicepValue<int> BackupIntervalInMinutes 
    {
        get { Initialize(); return _backupIntervalInMinutes!; }
        set { Initialize(); _backupIntervalInMinutes!.Assign(value); }
    }
    private BicepValue<int>? _backupIntervalInMinutes;

    /// <summary>
    /// An integer representing the time (in hours) that each backup is
    /// retained.
    /// </summary>
    public BicepValue<int> BackupRetentionIntervalInHours 
    {
        get { Initialize(); return _backupRetentionIntervalInHours!; }
        set { Initialize(); _backupRetentionIntervalInHours!.Assign(value); }
    }
    private BicepValue<int>? _backupRetentionIntervalInHours;

    /// <summary>
    /// Enum to indicate type of backup residency.
    /// </summary>
    public BicepValue<CosmosDBBackupStorageRedundancy> BackupStorageRedundancy 
    {
        get { Initialize(); return _backupStorageRedundancy!; }
        set { Initialize(); _backupStorageRedundancy!.Assign(value); }
    }
    private BicepValue<CosmosDBBackupStorageRedundancy>? _backupStorageRedundancy;

    /// <summary>
    /// Creates a new PeriodicModeProperties.
    /// </summary>
    public PeriodicModeProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of PeriodicModeProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _backupIntervalInMinutes = DefineProperty<int>("BackupIntervalInMinutes", ["backupIntervalInMinutes"]);
        _backupRetentionIntervalInHours = DefineProperty<int>("BackupRetentionIntervalInHours", ["backupRetentionIntervalInHours"]);
        _backupStorageRedundancy = DefineProperty<CosmosDBBackupStorageRedundancy>("BackupStorageRedundancy", ["backupStorageRedundancy"]);
    }
}
