// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// The object representing periodic mode backup policy.
/// </summary>
public partial class PeriodicModeBackupPolicy : CosmosDBAccountBackupPolicy
{
    /// <summary>
    /// Configuration values for periodic mode backup.
    /// </summary>
    public PeriodicModeProperties PeriodicModeProperties 
    {
        get { Initialize(); return _periodicModeProperties!; }
        set { Initialize(); AssignOrReplace(ref _periodicModeProperties, value); }
    }
    private PeriodicModeProperties? _periodicModeProperties;

    /// <summary>
    /// Creates a new PeriodicModeBackupPolicy.
    /// </summary>
    public PeriodicModeBackupPolicy() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of PeriodicModeBackupPolicy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("type", ["type"], defaultValue: "Periodic");
        _periodicModeProperties = DefineModelProperty<PeriodicModeProperties>("PeriodicModeProperties", ["periodicModeProperties"]);
    }
}
