// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// The set of roles permitted through this Role Definition.
/// </summary>
public partial class MongoDBRole : ProvisionableConstruct
{
    /// <summary>
    /// The database name the role is applied.
    /// </summary>
    public BicepValue<string> DBName 
    {
        get { Initialize(); return _dBName!; }
        set { Initialize(); _dBName!.Assign(value); }
    }
    private BicepValue<string>? _dBName;

    /// <summary>
    /// The role name.
    /// </summary>
    public BicepValue<string> Role 
    {
        get { Initialize(); return _role!; }
        set { Initialize(); _role!.Assign(value); }
    }
    private BicepValue<string>? _role;

    /// <summary>
    /// Creates a new MongoDBRole.
    /// </summary>
    public MongoDBRole()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of MongoDBRole.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _dBName = DefineProperty<string>("DBName", ["db"]);
        _role = DefineProperty<string>("Role", ["role"]);
    }
}
