// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// An Azure Cosmos DB Mongo DB Resource.
/// </summary>
public partial class MongoDBPrivilegeResourceInfo : ProvisionableConstruct
{
    /// <summary>
    /// The database name the role is applied.
    /// </summary>
    public BicepValue<string> DBName 
    {
        get { Initialize(); return _dBName!; }
        set { Initialize(); _dBName!.Assign(value); }
    }
    private BicepValue<string>? _dBName;

    /// <summary>
    /// The collection name the role is applied.
    /// </summary>
    public BicepValue<string> Collection 
    {
        get { Initialize(); return _collection!; }
        set { Initialize(); _collection!.Assign(value); }
    }
    private BicepValue<string>? _collection;

    /// <summary>
    /// Creates a new MongoDBPrivilegeResourceInfo.
    /// </summary>
    public MongoDBPrivilegeResourceInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of MongoDBPrivilegeResourceInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _dBName = DefineProperty<string>("DBName", ["db"]);
        _collection = DefineProperty<string>("Collection", ["collection"]);
    }
}
