// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// The set of data plane operations permitted through this Role Definition.
/// </summary>
public partial class MongoDBPrivilege : ProvisionableConstruct
{
    /// <summary>
    /// An Azure Cosmos DB Mongo DB Resource.
    /// </summary>
    public MongoDBPrivilegeResourceInfo Resource 
    {
        get { Initialize(); return _resource!; }
        set { Initialize(); AssignOrReplace(ref _resource, value); }
    }
    private MongoDBPrivilegeResourceInfo? _resource;

    /// <summary>
    /// An array of actions that are allowed.
    /// </summary>
    public BicepList<string> Actions 
    {
        get { Initialize(); return _actions!; }
        set { Initialize(); _actions!.Assign(value); }
    }
    private BicepList<string>? _actions;

    /// <summary>
    /// Creates a new MongoDBPrivilege.
    /// </summary>
    public MongoDBPrivilege()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of MongoDBPrivilege.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _resource = DefineModelProperty<MongoDBPrivilegeResourceInfo>("Resource", ["resource"]);
        _actions = DefineListProperty<string>("Actions", ["actions"]);
    }
}
