// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Cosmos DB MongoDB collection index options.
/// </summary>
public partial class MongoDBIndexConfig : ProvisionableConstruct
{
    /// <summary>
    /// Expire after seconds.
    /// </summary>
    public BicepValue<int> ExpireAfterSeconds 
    {
        get { Initialize(); return _expireAfterSeconds!; }
        set { Initialize(); _expireAfterSeconds!.Assign(value); }
    }
    private BicepValue<int>? _expireAfterSeconds;

    /// <summary>
    /// Is unique or not.
    /// </summary>
    public BicepValue<bool> IsUnique 
    {
        get { Initialize(); return _isUnique!; }
        set { Initialize(); _isUnique!.Assign(value); }
    }
    private BicepValue<bool>? _isUnique;

    /// <summary>
    /// Creates a new MongoDBIndexConfig.
    /// </summary>
    public MongoDBIndexConfig()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of MongoDBIndexConfig.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _expireAfterSeconds = DefineProperty<int>("ExpireAfterSeconds", ["expireAfterSeconds"]);
        _isUnique = DefineProperty<bool>("IsUnique", ["unique"]);
    }
}
