// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Cosmos DB MongoDB collection index key.
/// </summary>
public partial class MongoDBIndex : ProvisionableConstruct
{
    /// <summary>
    /// List of keys for each MongoDB collection in the Azure Cosmos DB service.
    /// </summary>
    public BicepList<string> Keys 
    {
        get { Initialize(); return _keys!; }
        set { Initialize(); _keys!.Assign(value); }
    }
    private BicepList<string>? _keys;

    /// <summary>
    /// Cosmos DB MongoDB collection index key options.
    /// </summary>
    public MongoDBIndexConfig Options 
    {
        get { Initialize(); return _options!; }
        set { Initialize(); AssignOrReplace(ref _options, value); }
    }
    private MongoDBIndexConfig? _options;

    /// <summary>
    /// Creates a new MongoDBIndex.
    /// </summary>
    public MongoDBIndex()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of MongoDBIndex.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _keys = DefineListProperty<string>("Keys", ["key", "keys"]);
        _options = DefineModelProperty<MongoDBIndexConfig>("Options", ["options"]);
    }
}
