// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Cosmos DB MongoDB collection resource object.
/// </summary>
public partial class MongoDBCollectionResourceInfo : ProvisionableConstruct
{
    /// <summary>
    /// Name of the Cosmos DB MongoDB collection.
    /// </summary>
    public BicepValue<string> CollectionName 
    {
        get { Initialize(); return _collectionName!; }
        set { Initialize(); _collectionName!.Assign(value); }
    }
    private BicepValue<string>? _collectionName;

    /// <summary>
    /// A key-value pair of shard keys to be applied for the request.
    /// </summary>
    public BicepDictionary<string> ShardKey 
    {
        get { Initialize(); return _shardKey!; }
        set { Initialize(); _shardKey!.Assign(value); }
    }
    private BicepDictionary<string>? _shardKey;

    /// <summary>
    /// List of index keys.
    /// </summary>
    public BicepList<MongoDBIndex> Indexes 
    {
        get { Initialize(); return _indexes!; }
        set { Initialize(); _indexes!.Assign(value); }
    }
    private BicepList<MongoDBIndex>? _indexes;

    /// <summary>
    /// Analytical TTL.
    /// </summary>
    public BicepValue<int> AnalyticalStorageTtl 
    {
        get { Initialize(); return _analyticalStorageTtl!; }
        set { Initialize(); _analyticalStorageTtl!.Assign(value); }
    }
    private BicepValue<int>? _analyticalStorageTtl;

    /// <summary>
    /// Parameters to indicate the information about the restore.
    /// </summary>
    public ResourceRestoreParameters RestoreParameters 
    {
        get { Initialize(); return _restoreParameters!; }
        set { Initialize(); AssignOrReplace(ref _restoreParameters, value); }
    }
    private ResourceRestoreParameters? _restoreParameters;

    /// <summary>
    /// Enum to indicate the mode of resource creation.
    /// </summary>
    public BicepValue<CosmosDBAccountCreateMode> CreateMode 
    {
        get { Initialize(); return _createMode!; }
        set { Initialize(); _createMode!.Assign(value); }
    }
    private BicepValue<CosmosDBAccountCreateMode>? _createMode;

    /// <summary>
    /// Creates a new MongoDBCollectionResourceInfo.
    /// </summary>
    public MongoDBCollectionResourceInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// MongoDBCollectionResourceInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _collectionName = DefineProperty<string>("CollectionName", ["id"]);
        _shardKey = DefineDictionaryProperty<string>("ShardKey", ["shardKey"]);
        _indexes = DefineListProperty<MongoDBIndex>("Indexes", ["indexes"]);
        _analyticalStorageTtl = DefineProperty<int>("AnalyticalStorageTtl", ["analyticalStorageTtl"]);
        _restoreParameters = DefineModelProperty<ResourceRestoreParameters>("RestoreParameters", ["restoreParameters"]);
        _createMode = DefineProperty<CosmosDBAccountCreateMode>("CreateMode", ["createMode"]);
    }
}
