// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Properties for MaterializedViewsBuilderServiceResource.
/// </summary>
public partial class MaterializedViewsBuilderServiceProperties : CosmosDBServiceProperties
{
    /// <summary>
    /// An array that contains all of the locations for the service.
    /// </summary>
    public BicepList<MaterializedViewsBuilderRegionalService> Locations 
    {
        get { Initialize(); return _locations!; }
    }
    private BicepList<MaterializedViewsBuilderRegionalService>? _locations;

    /// <summary>
    /// Creates a new MaterializedViewsBuilderServiceProperties.
    /// </summary>
    public MaterializedViewsBuilderServiceProperties() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// MaterializedViewsBuilderServiceProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("serviceType", ["serviceType"], defaultValue: "MaterializedViewsBuilder");
        _locations = DefineListProperty<MaterializedViewsBuilderRegionalService>("Locations", ["locations"], isOutput: true);
    }
}
