// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Specific Gremlin Databases to restore.
/// </summary>
public partial class GremlinDatabaseRestoreResourceInfo : ProvisionableConstruct
{
    /// <summary>
    /// The name of the gremlin database available for restore.
    /// </summary>
    public BicepValue<string> DatabaseName 
    {
        get { Initialize(); return _databaseName!; }
        set { Initialize(); _databaseName!.Assign(value); }
    }
    private BicepValue<string>? _databaseName;

    /// <summary>
    /// The names of the graphs available for restore.
    /// </summary>
    public BicepList<string> GraphNames 
    {
        get { Initialize(); return _graphNames!; }
        set { Initialize(); _graphNames!.Assign(value); }
    }
    private BicepList<string>? _graphNames;

    /// <summary>
    /// Creates a new GremlinDatabaseRestoreResourceInfo.
    /// </summary>
    public GremlinDatabaseRestoreResourceInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// GremlinDatabaseRestoreResourceInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _databaseName = DefineProperty<string>("DatabaseName", ["databaseName"]);
        _graphNames = DefineListProperty<string>("GraphNames", ["graphNames"]);
    }
}
