// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Cosmos DB Gremlin database resource object.
/// </summary>
public partial class GremlinDatabaseResourceInfo : ProvisionableConstruct
{
    /// <summary>
    /// Name of the Cosmos DB Gremlin database.
    /// </summary>
    public BicepValue<string> DatabaseName 
    {
        get { Initialize(); return _databaseName!; }
        set { Initialize(); _databaseName!.Assign(value); }
    }
    private BicepValue<string>? _databaseName;

    /// <summary>
    /// Parameters to indicate the information about the restore.
    /// </summary>
    public ResourceRestoreParameters RestoreParameters 
    {
        get { Initialize(); return _restoreParameters!; }
        set { Initialize(); AssignOrReplace(ref _restoreParameters, value); }
    }
    private ResourceRestoreParameters? _restoreParameters;

    /// <summary>
    /// Enum to indicate the mode of resource creation.
    /// </summary>
    public BicepValue<CosmosDBAccountCreateMode> CreateMode 
    {
        get { Initialize(); return _createMode!; }
        set { Initialize(); _createMode!.Assign(value); }
    }
    private BicepValue<CosmosDBAccountCreateMode>? _createMode;

    /// <summary>
    /// Creates a new GremlinDatabaseResourceInfo.
    /// </summary>
    public GremlinDatabaseResourceInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of GremlinDatabaseResourceInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _databaseName = DefineProperty<string>("DatabaseName", ["id"]);
        _restoreParameters = DefineModelProperty<ResourceRestoreParameters>("RestoreParameters", ["restoreParameters"]);
        _createMode = DefineProperty<CosmosDBAccountCreateMode>("CreateMode", ["createMode"]);
    }
}
