// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// The ExtendedCosmosDBSqlDatabaseResourceInfo.
/// </summary>
public partial class ExtendedCosmosDBSqlDatabaseResourceInfo : CosmosDBSqlDatabaseResourceInfo
{
    /// <summary>
    /// A system generated property that specified the addressable path of the
    /// collections resource.
    /// </summary>
    public BicepValue<string> Colls 
    {
        get { Initialize(); return _colls!; }
        set { Initialize(); _colls!.Assign(value); }
    }
    private BicepValue<string>? _colls;

    /// <summary>
    /// A system generated property that specifies the addressable path of the
    /// users resource.
    /// </summary>
    public BicepValue<string> Users 
    {
        get { Initialize(); return _users!; }
        set { Initialize(); _users!.Assign(value); }
    }
    private BicepValue<string>? _users;

    /// <summary>
    /// A system generated property. A unique identifier.
    /// </summary>
    public BicepValue<string> Rid 
    {
        get { Initialize(); return _rid!; }
    }
    private BicepValue<string>? _rid;

    /// <summary>
    /// A system generated property that denotes the last updated timestamp of
    /// the resource.
    /// </summary>
    public BicepValue<float> Timestamp 
    {
        get { Initialize(); return _timestamp!; }
    }
    private BicepValue<float>? _timestamp;

    /// <summary>
    /// A system generated property representing the resource etag required for
    /// optimistic concurrency control.
    /// </summary>
    public BicepValue<ETag> ETag 
    {
        get { Initialize(); return _eTag!; }
    }
    private BicepValue<ETag>? _eTag;

    /// <summary>
    /// Creates a new ExtendedCosmosDBSqlDatabaseResourceInfo.
    /// </summary>
    public ExtendedCosmosDBSqlDatabaseResourceInfo() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ExtendedCosmosDBSqlDatabaseResourceInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _colls = DefineProperty<string>("Colls", ["_colls"]);
        _users = DefineProperty<string>("Users", ["_users"]);
        _rid = DefineProperty<string>("Rid", ["_rid"], isOutput: true);
        _timestamp = DefineProperty<float>("Timestamp", ["_ts"], isOutput: true);
        _eTag = DefineProperty<ETag>("ETag", ["_etag"], isOutput: true);
    }
}
