// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// The ExtendedCassandraKeyspaceResourceInfo.
/// </summary>
public partial class ExtendedCassandraKeyspaceResourceInfo : ProvisionableConstruct
{
    /// <summary>
    /// A system generated property. A unique identifier.
    /// </summary>
    public BicepValue<string> Rid 
    {
        get { Initialize(); return _rid!; }
    }
    private BicepValue<string>? _rid;

    /// <summary>
    /// A system generated property that denotes the last updated timestamp of
    /// the resource.
    /// </summary>
    public BicepValue<float> Timestamp 
    {
        get { Initialize(); return _timestamp!; }
    }
    private BicepValue<float>? _timestamp;

    /// <summary>
    /// A system generated property representing the resource etag required for
    /// optimistic concurrency control.
    /// </summary>
    public BicepValue<ETag> ETag 
    {
        get { Initialize(); return _eTag!; }
    }
    private BicepValue<ETag>? _eTag;

    /// <summary>
    /// Name of the Cosmos DB Cassandra keyspace.
    /// </summary>
    public BicepValue<string> KeyspaceName 
    {
        get { Initialize(); return _keyspaceName!; }
        set { Initialize(); _keyspaceName!.Assign(value); }
    }
    private BicepValue<string>? _keyspaceName;

    /// <summary>
    /// Creates a new ExtendedCassandraKeyspaceResourceInfo.
    /// </summary>
    public ExtendedCassandraKeyspaceResourceInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ExtendedCassandraKeyspaceResourceInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _rid = DefineProperty<string>("Rid", ["_rid"], isOutput: true);
        _timestamp = DefineProperty<float>("Timestamp", ["_ts"], isOutput: true);
        _eTag = DefineProperty<ETag>("ETag", ["_etag"], isOutput: true);
        _keyspaceName = DefineProperty<string>("KeyspaceName", ["id"]);
    }
}
