// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Error Response.
/// </summary>
public partial class ErrorResponse : ProvisionableConstruct
{
    /// <summary>
    /// Error code.
    /// </summary>
    public BicepValue<string> Code 
    {
        get { Initialize(); return _code!; }
    }
    private BicepValue<string>? _code;

    /// <summary>
    /// Error message indicating why the operation failed.
    /// </summary>
    public BicepValue<string> Message 
    {
        get { Initialize(); return _message!; }
    }
    private BicepValue<string>? _message;

    /// <summary>
    /// Creates a new ErrorResponse.
    /// </summary>
    public ErrorResponse()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ErrorResponse.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _code = DefineProperty<string>("Code", ["code"], isOutput: true);
        _message = DefineProperty<string>("Message", ["message"], isOutput: true);
    }
}
