// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Specific Databases to restore.
/// </summary>
public partial class DatabaseRestoreResourceInfo : ProvisionableConstruct
{
    /// <summary>
    /// The name of the database available for restore.
    /// </summary>
    public BicepValue<string> DatabaseName 
    {
        get { Initialize(); return _databaseName!; }
        set { Initialize(); _databaseName!.Assign(value); }
    }
    private BicepValue<string>? _databaseName;

    /// <summary>
    /// The names of the collections available for restore.
    /// </summary>
    public BicepList<string> CollectionNames 
    {
        get { Initialize(); return _collectionNames!; }
        set { Initialize(); _collectionNames!.Assign(value); }
    }
    private BicepList<string>? _collectionNames;

    /// <summary>
    /// Creates a new DatabaseRestoreResourceInfo.
    /// </summary>
    public DatabaseRestoreResourceInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of DatabaseRestoreResourceInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _databaseName = DefineProperty<string>("DatabaseName", ["databaseName"]);
        _collectionNames = DefineListProperty<string>("CollectionNames", ["collectionNames"]);
    }
}
