// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// The metadata related to each access key for the given Cosmos DB database
/// account.
/// </summary>
public partial class DatabaseAccountKeysMetadata : ProvisionableConstruct
{
    /// <summary>
    /// Generation time in UTC of the key in ISO-8601 format. If the value is
    /// missing from the object, it means that the last key regeneration was
    /// triggered before 2022-06-18.
    /// </summary>
    public BicepValue<DateTimeOffset> PrimaryMasterKeyGeneratedOn 
    {
        get { Initialize(); return _primaryMasterKeyGeneratedOn!; }
    }
    private BicepValue<DateTimeOffset>? _primaryMasterKeyGeneratedOn;

    /// <summary>
    /// Generation time in UTC of the key in ISO-8601 format. If the value is
    /// missing from the object, it means that the last key regeneration was
    /// triggered before 2022-06-18.
    /// </summary>
    public BicepValue<DateTimeOffset> SecondaryMasterKeyGeneratedOn 
    {
        get { Initialize(); return _secondaryMasterKeyGeneratedOn!; }
    }
    private BicepValue<DateTimeOffset>? _secondaryMasterKeyGeneratedOn;

    /// <summary>
    /// Generation time in UTC of the key in ISO-8601 format. If the value is
    /// missing from the object, it means that the last key regeneration was
    /// triggered before 2022-06-18.
    /// </summary>
    public BicepValue<DateTimeOffset> PrimaryReadonlyMasterKeyGeneratedOn 
    {
        get { Initialize(); return _primaryReadonlyMasterKeyGeneratedOn!; }
    }
    private BicepValue<DateTimeOffset>? _primaryReadonlyMasterKeyGeneratedOn;

    /// <summary>
    /// Generation time in UTC of the key in ISO-8601 format. If the value is
    /// missing from the object, it means that the last key regeneration was
    /// triggered before 2022-06-18.
    /// </summary>
    public BicepValue<DateTimeOffset> SecondaryReadonlyMasterKeyGeneratedOn 
    {
        get { Initialize(); return _secondaryReadonlyMasterKeyGeneratedOn!; }
    }
    private BicepValue<DateTimeOffset>? _secondaryReadonlyMasterKeyGeneratedOn;

    /// <summary>
    /// Creates a new DatabaseAccountKeysMetadata.
    /// </summary>
    public DatabaseAccountKeysMetadata()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of DatabaseAccountKeysMetadata.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _primaryMasterKeyGeneratedOn = DefineProperty<DateTimeOffset>("PrimaryMasterKeyGeneratedOn", ["primaryMasterKey", "generationTime"], isOutput: true);
        _secondaryMasterKeyGeneratedOn = DefineProperty<DateTimeOffset>("SecondaryMasterKeyGeneratedOn", ["secondaryMasterKey", "generationTime"], isOutput: true);
        _primaryReadonlyMasterKeyGeneratedOn = DefineProperty<DateTimeOffset>("PrimaryReadonlyMasterKeyGeneratedOn", ["primaryReadonlyMasterKey", "generationTime"], isOutput: true);
        _secondaryReadonlyMasterKeyGeneratedOn = DefineProperty<DateTimeOffset>("SecondaryReadonlyMasterKeyGeneratedOn", ["secondaryReadonlyMasterKey", "generationTime"], isOutput: true);
    }
}
