// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Properties for DataTransferServiceResource.
/// </summary>
public partial class DataTransferServiceProperties : CosmosDBServiceProperties
{
    /// <summary>
    /// An array that contains all of the locations for the service.
    /// </summary>
    public BicepList<DataTransferRegionalService> Locations 
    {
        get { Initialize(); return _locations!; }
    }
    private BicepList<DataTransferRegionalService>? _locations;

    /// <summary>
    /// Creates a new DataTransferServiceProperties.
    /// </summary>
    public DataTransferServiceProperties() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// DataTransferServiceProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("serviceType", ["serviceType"], defaultValue: "DataTransfer");
        _locations = DefineListProperty<DataTransferRegionalService>("Locations", ["locations"], isOutput: true);
    }
}
