// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Virtual Network ACL Rule object.
/// </summary>
public partial class CosmosDBVirtualNetworkRule : ProvisionableConstruct
{
    /// <summary>
    /// Resource ID of a subnet, for example:
    /// /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
        set { Initialize(); _id!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Create firewall rule before the virtual network has vnet service
    /// endpoint enabled.
    /// </summary>
    public BicepValue<bool> IgnoreMissingVnetServiceEndpoint 
    {
        get { Initialize(); return _ignoreMissingVnetServiceEndpoint!; }
        set { Initialize(); _ignoreMissingVnetServiceEndpoint!.Assign(value); }
    }
    private BicepValue<bool>? _ignoreMissingVnetServiceEndpoint;

    /// <summary>
    /// Creates a new CosmosDBVirtualNetworkRule.
    /// </summary>
    public CosmosDBVirtualNetworkRule()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CosmosDBVirtualNetworkRule.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"]);
        _ignoreMissingVnetServiceEndpoint = DefineProperty<bool>("IgnoreMissingVnetServiceEndpoint", ["ignoreMissingVNetServiceEndpoint"]);
    }
}
