// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Cosmos DB table resource object.
/// </summary>
public partial class CosmosDBTableResourceInfo : ProvisionableConstruct
{
    /// <summary>
    /// Name of the Cosmos DB table.
    /// </summary>
    public BicepValue<string> TableName 
    {
        get { Initialize(); return _tableName!; }
        set { Initialize(); _tableName!.Assign(value); }
    }
    private BicepValue<string>? _tableName;

    /// <summary>
    /// Parameters to indicate the information about the restore.
    /// </summary>
    public ResourceRestoreParameters RestoreParameters 
    {
        get { Initialize(); return _restoreParameters!; }
        set { Initialize(); AssignOrReplace(ref _restoreParameters, value); }
    }
    private ResourceRestoreParameters? _restoreParameters;

    /// <summary>
    /// Enum to indicate the mode of resource creation.
    /// </summary>
    public BicepValue<CosmosDBAccountCreateMode> CreateMode 
    {
        get { Initialize(); return _createMode!; }
        set { Initialize(); _createMode!.Assign(value); }
    }
    private BicepValue<CosmosDBAccountCreateMode>? _createMode;

    /// <summary>
    /// Creates a new CosmosDBTableResourceInfo.
    /// </summary>
    public CosmosDBTableResourceInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CosmosDBTableResourceInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _tableName = DefineProperty<string>("TableName", ["id"]);
        _restoreParameters = DefineModelProperty<ResourceRestoreParameters>("RestoreParameters", ["restoreParameters"]);
        _createMode = DefineProperty<CosmosDBAccountCreateMode>("CreateMode", ["createMode"]);
    }
}
