// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Cosmos DB SQL userDefinedFunction resource object.
/// </summary>
public partial class CosmosDBSqlUserDefinedFunctionResourceInfo : ProvisionableConstruct
{
    /// <summary>
    /// Name of the Cosmos DB SQL userDefinedFunction.
    /// </summary>
    public BicepValue<string> FunctionName 
    {
        get { Initialize(); return _functionName!; }
        set { Initialize(); _functionName!.Assign(value); }
    }
    private BicepValue<string>? _functionName;

    /// <summary>
    /// Body of the User Defined Function.
    /// </summary>
    public BicepValue<string> Body 
    {
        get { Initialize(); return _body!; }
        set { Initialize(); _body!.Assign(value); }
    }
    private BicepValue<string>? _body;

    /// <summary>
    /// Creates a new CosmosDBSqlUserDefinedFunctionResourceInfo.
    /// </summary>
    public CosmosDBSqlUserDefinedFunctionResourceInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// CosmosDBSqlUserDefinedFunctionResourceInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _functionName = DefineProperty<string>("FunctionName", ["id"]);
        _body = DefineProperty<string>("Body", ["body"]);
    }
}
