// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Cosmos DB SQL trigger resource object.
/// </summary>
public partial class CosmosDBSqlTriggerResourceInfo : ProvisionableConstruct
{
    /// <summary>
    /// Name of the Cosmos DB SQL trigger.
    /// </summary>
    public BicepValue<string> TriggerName 
    {
        get { Initialize(); return _triggerName!; }
        set { Initialize(); _triggerName!.Assign(value); }
    }
    private BicepValue<string>? _triggerName;

    /// <summary>
    /// Body of the Trigger.
    /// </summary>
    public BicepValue<string> Body 
    {
        get { Initialize(); return _body!; }
        set { Initialize(); _body!.Assign(value); }
    }
    private BicepValue<string>? _body;

    /// <summary>
    /// Type of the Trigger.
    /// </summary>
    public BicepValue<CosmosDBSqlTriggerType> TriggerType 
    {
        get { Initialize(); return _triggerType!; }
        set { Initialize(); _triggerType!.Assign(value); }
    }
    private BicepValue<CosmosDBSqlTriggerType>? _triggerType;

    /// <summary>
    /// The operation the trigger is associated with.
    /// </summary>
    public BicepValue<CosmosDBSqlTriggerOperation> TriggerOperation 
    {
        get { Initialize(); return _triggerOperation!; }
        set { Initialize(); _triggerOperation!.Assign(value); }
    }
    private BicepValue<CosmosDBSqlTriggerOperation>? _triggerOperation;

    /// <summary>
    /// Creates a new CosmosDBSqlTriggerResourceInfo.
    /// </summary>
    public CosmosDBSqlTriggerResourceInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// CosmosDBSqlTriggerResourceInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _triggerName = DefineProperty<string>("TriggerName", ["id"]);
        _body = DefineProperty<string>("Body", ["body"]);
        _triggerType = DefineProperty<CosmosDBSqlTriggerType>("TriggerType", ["triggerType"]);
        _triggerOperation = DefineProperty<CosmosDBSqlTriggerOperation>("TriggerOperation", ["triggerOperation"]);
    }
}
