// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// The set of data plane operations permitted through this Role Definition.
/// </summary>
public partial class CosmosDBSqlRolePermission : ProvisionableConstruct
{
    /// <summary>
    /// An array of data actions that are allowed.
    /// </summary>
    public BicepList<string> DataActions 
    {
        get { Initialize(); return _dataActions!; }
        set { Initialize(); _dataActions!.Assign(value); }
    }
    private BicepList<string>? _dataActions;

    /// <summary>
    /// An array of data actions that are denied.
    /// </summary>
    public BicepList<string> NotDataActions 
    {
        get { Initialize(); return _notDataActions!; }
        set { Initialize(); _notDataActions!.Assign(value); }
    }
    private BicepList<string>? _notDataActions;

    /// <summary>
    /// Creates a new CosmosDBSqlRolePermission.
    /// </summary>
    public CosmosDBSqlRolePermission()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CosmosDBSqlRolePermission.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _dataActions = DefineListProperty<string>("DataActions", ["dataActions"]);
        _notDataActions = DefineListProperty<string>("NotDataActions", ["notDataActions"]);
    }
}
