// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Cosmos DB SQL container resource object.
/// </summary>
public partial class CosmosDBSqlContainerResourceInfo : ProvisionableConstruct
{
    /// <summary>
    /// Name of the Cosmos DB SQL container.
    /// </summary>
    public BicepValue<string> ContainerName 
    {
        get { Initialize(); return _containerName!; }
        set { Initialize(); _containerName!.Assign(value); }
    }
    private BicepValue<string>? _containerName;

    /// <summary>
    /// The configuration of the indexing policy. By default, the indexing is
    /// automatic for all document paths within the container.
    /// </summary>
    public CosmosDBIndexingPolicy IndexingPolicy 
    {
        get { Initialize(); return _indexingPolicy!; }
        set { Initialize(); AssignOrReplace(ref _indexingPolicy, value); }
    }
    private CosmosDBIndexingPolicy? _indexingPolicy;

    /// <summary>
    /// The configuration of the partition key to be used for partitioning data
    /// into multiple partitions.
    /// </summary>
    public CosmosDBContainerPartitionKey PartitionKey 
    {
        get { Initialize(); return _partitionKey!; }
        set { Initialize(); AssignOrReplace(ref _partitionKey, value); }
    }
    private CosmosDBContainerPartitionKey? _partitionKey;

    /// <summary>
    /// Default time to live.
    /// </summary>
    public BicepValue<int> DefaultTtl 
    {
        get { Initialize(); return _defaultTtl!; }
        set { Initialize(); _defaultTtl!.Assign(value); }
    }
    private BicepValue<int>? _defaultTtl;

    /// <summary>
    /// List of unique keys on that enforces uniqueness constraint on documents
    /// in the collection in the Azure Cosmos DB service.
    /// </summary>
    public BicepList<CosmosDBUniqueKey> UniqueKeys 
    {
        get { Initialize(); return _uniqueKeys!; }
        set { Initialize(); _uniqueKeys!.Assign(value); }
    }
    private BicepList<CosmosDBUniqueKey>? _uniqueKeys;

    /// <summary>
    /// The conflict resolution policy for the container.
    /// </summary>
    public ConflictResolutionPolicy ConflictResolutionPolicy 
    {
        get { Initialize(); return _conflictResolutionPolicy!; }
        set { Initialize(); AssignOrReplace(ref _conflictResolutionPolicy, value); }
    }
    private ConflictResolutionPolicy? _conflictResolutionPolicy;

    /// <summary>
    /// The client encryption policy for the container.
    /// </summary>
    public CosmosDBClientEncryptionPolicy ClientEncryptionPolicy 
    {
        get { Initialize(); return _clientEncryptionPolicy!; }
        set { Initialize(); AssignOrReplace(ref _clientEncryptionPolicy, value); }
    }
    private CosmosDBClientEncryptionPolicy? _clientEncryptionPolicy;

    /// <summary>
    /// Analytical TTL.
    /// </summary>
    public BicepValue<long> AnalyticalStorageTtl 
    {
        get { Initialize(); return _analyticalStorageTtl!; }
        set { Initialize(); _analyticalStorageTtl!.Assign(value); }
    }
    private BicepValue<long>? _analyticalStorageTtl;

    /// <summary>
    /// Parameters to indicate the information about the restore.
    /// </summary>
    public ResourceRestoreParameters RestoreParameters 
    {
        get { Initialize(); return _restoreParameters!; }
        set { Initialize(); AssignOrReplace(ref _restoreParameters, value); }
    }
    private ResourceRestoreParameters? _restoreParameters;

    /// <summary>
    /// Enum to indicate the mode of resource creation.
    /// </summary>
    public BicepValue<CosmosDBAccountCreateMode> CreateMode 
    {
        get { Initialize(); return _createMode!; }
        set { Initialize(); _createMode!.Assign(value); }
    }
    private BicepValue<CosmosDBAccountCreateMode>? _createMode;

    /// <summary>
    /// The configuration for defining Materialized Views. This must be
    /// specified only for creating a Materialized View container.
    /// </summary>
    public MaterializedViewDefinition MaterializedViewDefinition 
    {
        get { Initialize(); return _materializedViewDefinition!; }
        set { Initialize(); AssignOrReplace(ref _materializedViewDefinition, value); }
    }
    private MaterializedViewDefinition? _materializedViewDefinition;

    /// <summary>
    /// List of computed properties.
    /// </summary>
    public BicepList<ComputedProperty> ComputedProperties 
    {
        get { Initialize(); return _computedProperties!; }
        set { Initialize(); _computedProperties!.Assign(value); }
    }
    private BicepList<ComputedProperty>? _computedProperties;

    /// <summary>
    /// Creates a new CosmosDBSqlContainerResourceInfo.
    /// </summary>
    public CosmosDBSqlContainerResourceInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// CosmosDBSqlContainerResourceInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _containerName = DefineProperty<string>("ContainerName", ["id"]);
        _indexingPolicy = DefineModelProperty<CosmosDBIndexingPolicy>("IndexingPolicy", ["indexingPolicy"]);
        _partitionKey = DefineModelProperty<CosmosDBContainerPartitionKey>("PartitionKey", ["partitionKey"]);
        _defaultTtl = DefineProperty<int>("DefaultTtl", ["defaultTtl"]);
        _uniqueKeys = DefineListProperty<CosmosDBUniqueKey>("UniqueKeys", ["uniqueKeyPolicy", "uniqueKeys"]);
        _conflictResolutionPolicy = DefineModelProperty<ConflictResolutionPolicy>("ConflictResolutionPolicy", ["conflictResolutionPolicy"]);
        _clientEncryptionPolicy = DefineModelProperty<CosmosDBClientEncryptionPolicy>("ClientEncryptionPolicy", ["clientEncryptionPolicy"]);
        _analyticalStorageTtl = DefineProperty<long>("AnalyticalStorageTtl", ["analyticalStorageTtl"]);
        _restoreParameters = DefineModelProperty<ResourceRestoreParameters>("RestoreParameters", ["restoreParameters"]);
        _createMode = DefineProperty<CosmosDBAccountCreateMode>("CreateMode", ["createMode"]);
        _materializedViewDefinition = DefineModelProperty<MaterializedViewDefinition>("MaterializedViewDefinition", ["materializedViewDefinition"]);
        _computedProperties = DefineListProperty<ComputedProperty>("ComputedProperties", ["computedProperties"]);
    }
}
