// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Cosmos DB client encryption key resource object.
/// </summary>
public partial class CosmosDBSqlClientEncryptionKeyResourceInfo : ProvisionableConstruct
{
    /// <summary>
    /// Name of the ClientEncryptionKey.
    /// </summary>
    public BicepValue<string> Id 
    {
        get { Initialize(); return _id!; }
        set { Initialize(); _id!.Assign(value); }
    }
    private BicepValue<string>? _id;

    /// <summary>
    /// Encryption algorithm that will be used along with this client
    /// encryption key to encrypt/decrypt data.
    /// </summary>
    public BicepValue<string> EncryptionAlgorithm 
    {
        get { Initialize(); return _encryptionAlgorithm!; }
        set { Initialize(); _encryptionAlgorithm!.Assign(value); }
    }
    private BicepValue<string>? _encryptionAlgorithm;

    /// <summary>
    /// Wrapped (encrypted) form of the key represented as a byte array.
    /// </summary>
    public BicepValue<BinaryData> WrappedDataEncryptionKey 
    {
        get { Initialize(); return _wrappedDataEncryptionKey!; }
        set { Initialize(); _wrappedDataEncryptionKey!.Assign(value); }
    }
    private BicepValue<BinaryData>? _wrappedDataEncryptionKey;

    /// <summary>
    /// Metadata for the wrapping provider that can be used to unwrap the
    /// wrapped client encryption key.
    /// </summary>
    public CosmosDBKeyWrapMetadata KeyWrapMetadata 
    {
        get { Initialize(); return _keyWrapMetadata!; }
        set { Initialize(); AssignOrReplace(ref _keyWrapMetadata, value); }
    }
    private CosmosDBKeyWrapMetadata? _keyWrapMetadata;

    /// <summary>
    /// Creates a new CosmosDBSqlClientEncryptionKeyResourceInfo.
    /// </summary>
    public CosmosDBSqlClientEncryptionKeyResourceInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// CosmosDBSqlClientEncryptionKeyResourceInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _id = DefineProperty<string>("Id", ["id"]);
        _encryptionAlgorithm = DefineProperty<string>("EncryptionAlgorithm", ["encryptionAlgorithm"]);
        _wrappedDataEncryptionKey = DefineProperty<BinaryData>("WrappedDataEncryptionKey", ["wrappedDataEncryptionKey"]);
        _keyWrapMetadata = DefineModelProperty<CosmosDBKeyWrapMetadata>("KeyWrapMetadata", ["keyWrapMetadata"]);
    }
}
