// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Services response resource.             Please note
/// Azure.ResourceManager.CosmosDB.Models.CosmosDBServiceProperties is the
/// base class. According to the scenario, a derived class of the base class
/// might need to be assigned here, or this property needs to be casted to one
/// of the possible derived classes.             The available derived classes
/// include
/// Azure.ResourceManager.CosmosDB.Models.DataTransferServiceProperties,
/// Azure.ResourceManager.CosmosDB.Models.GraphApiComputeServiceProperties,
/// Azure.ResourceManager.CosmosDB.Models.MaterializedViewsBuilderServiceProperties
/// and
/// Azure.ResourceManager.CosmosDB.Models.SqlDedicatedGatewayServiceProperties.
/// </summary>
public partial class CosmosDBServiceProperties : ProvisionableConstruct
{
    /// <summary>
    /// Time of the last state change (ISO-8601 format).
    /// </summary>
    public BicepValue<DateTimeOffset> CreatedOn 
    {
        get { Initialize(); return _createdOn!; }
    }
    private BicepValue<DateTimeOffset>? _createdOn;

    /// <summary>
    /// Instance type for the service.
    /// </summary>
    public BicepValue<CosmosDBServiceSize> InstanceSize 
    {
        get { Initialize(); return _instanceSize!; }
        set { Initialize(); _instanceSize!.Assign(value); }
    }
    private BicepValue<CosmosDBServiceSize>? _instanceSize;

    /// <summary>
    /// Instance count for the service.
    /// </summary>
    public BicepValue<int> InstanceCount 
    {
        get { Initialize(); return _instanceCount!; }
        set { Initialize(); _instanceCount!.Assign(value); }
    }
    private BicepValue<int>? _instanceCount;

    /// <summary>
    /// Describes the status of a service.
    /// </summary>
    public BicepValue<CosmosDBServiceStatus> Status 
    {
        get { Initialize(); return _status!; }
    }
    private BicepValue<CosmosDBServiceStatus>? _status;

    /// <summary>
    /// Additional Properties                          To assign an object to
    /// the value of this property use
    /// System.BinaryData.FromObjectAsJson``1(``0,System.Text.Json.JsonSerializerOptions).
    /// To assign an already formatted json string to
    /// this property use System.BinaryData.FromString(System.String).
    /// Examples:
    /// BinaryData.FromObjectAsJson(&quot;foo&quot;)Creates a
    /// payload of
    /// &quot;foo&quot;.BinaryData.FromString(&quot;\&quot;foo\&quot;&quot;)Creates
    /// a payload of &quot;foo&quot;.BinaryData.FromObjectAsJson(new { key =
    /// &quot;value&quot; })Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.BinaryData.FromString(&quot;{\&quot;key\&quot;:
    /// \&quot;value\&quot;}&quot;)Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.
    /// </summary>
    public BicepDictionary<BinaryData> AdditionalProperties 
    {
        get { Initialize(); return _additionalProperties!; }
        set { Initialize(); _additionalProperties!.Assign(value); }
    }
    private BicepDictionary<BinaryData>? _additionalProperties;

    /// <summary>
    /// Creates a new CosmosDBServiceProperties.
    /// </summary>
    public CosmosDBServiceProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CosmosDBServiceProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _createdOn = DefineProperty<DateTimeOffset>("CreatedOn", ["creationTime"], isOutput: true);
        _instanceSize = DefineProperty<CosmosDBServiceSize>("InstanceSize", ["instanceSize"]);
        _instanceCount = DefineProperty<int>("InstanceCount", ["instanceCount"]);
        _status = DefineProperty<CosmosDBServiceStatus>("Status", ["status"], isOutput: true);
        _additionalProperties = DefineDictionaryProperty<BinaryData>("AdditionalProperties", ["AdditionalProperties"]);
    }
}
