// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Represents key wrap metadata that a key wrapping provider can use to
/// wrap/unwrap a client encryption key.
/// </summary>
public partial class CosmosDBKeyWrapMetadata : ProvisionableConstruct
{
    /// <summary>
    /// The name of associated KeyEncryptionKey (aka CustomerManagedKey).
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// ProviderName of KeyStoreProvider.
    /// </summary>
    public BicepValue<string> CosmosDBKeyWrapMetadataType 
    {
        get { Initialize(); return _cosmosDBKeyWrapMetadataType!; }
        set { Initialize(); _cosmosDBKeyWrapMetadataType!.Assign(value); }
    }
    private BicepValue<string>? _cosmosDBKeyWrapMetadataType;

    /// <summary>
    /// Reference / link to the KeyEncryptionKey.
    /// </summary>
    public BicepValue<string> Value 
    {
        get { Initialize(); return _value!; }
        set { Initialize(); _value!.Assign(value); }
    }
    private BicepValue<string>? _value;

    /// <summary>
    /// Algorithm used in wrapping and unwrapping of the data encryption key.
    /// </summary>
    public BicepValue<string> Algorithm 
    {
        get { Initialize(); return _algorithm!; }
        set { Initialize(); _algorithm!.Assign(value); }
    }
    private BicepValue<string>? _algorithm;

    /// <summary>
    /// Creates a new CosmosDBKeyWrapMetadata.
    /// </summary>
    public CosmosDBKeyWrapMetadata()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CosmosDBKeyWrapMetadata.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _cosmosDBKeyWrapMetadataType = DefineProperty<string>("CosmosDBKeyWrapMetadataType", ["type"]);
        _value = DefineProperty<string>("Value", ["value"]);
        _algorithm = DefineProperty<string>("Algorithm", ["algorithm"]);
    }
}
