// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Cosmos DB indexing policy.
/// </summary>
public partial class CosmosDBIndexingPolicy : ProvisionableConstruct
{
    /// <summary>
    /// Indicates if the indexing policy is automatic.
    /// </summary>
    public BicepValue<bool> IsAutomatic 
    {
        get { Initialize(); return _isAutomatic!; }
        set { Initialize(); _isAutomatic!.Assign(value); }
    }
    private BicepValue<bool>? _isAutomatic;

    /// <summary>
    /// Indicates the indexing mode.
    /// </summary>
    public BicepValue<CosmosDBIndexingMode> IndexingMode 
    {
        get { Initialize(); return _indexingMode!; }
        set { Initialize(); _indexingMode!.Assign(value); }
    }
    private BicepValue<CosmosDBIndexingMode>? _indexingMode;

    /// <summary>
    /// List of paths to include in the indexing.
    /// </summary>
    public BicepList<CosmosDBIncludedPath> IncludedPaths 
    {
        get { Initialize(); return _includedPaths!; }
        set { Initialize(); _includedPaths!.Assign(value); }
    }
    private BicepList<CosmosDBIncludedPath>? _includedPaths;

    /// <summary>
    /// List of paths to exclude from indexing.
    /// </summary>
    public BicepList<CosmosDBExcludedPath> ExcludedPaths 
    {
        get { Initialize(); return _excludedPaths!; }
        set { Initialize(); _excludedPaths!.Assign(value); }
    }
    private BicepList<CosmosDBExcludedPath>? _excludedPaths;

    /// <summary>
    /// List of composite path list.
    /// </summary>
    public BicepList<BicepList<CosmosDBCompositePath>> CompositeIndexes 
    {
        get { Initialize(); return _compositeIndexes!; }
        set { Initialize(); _compositeIndexes!.Assign(value); }
    }
    private BicepList<BicepList<CosmosDBCompositePath>>? _compositeIndexes;

    /// <summary>
    /// List of spatial specifics.
    /// </summary>
    public BicepList<SpatialSpec> SpatialIndexes 
    {
        get { Initialize(); return _spatialIndexes!; }
        set { Initialize(); _spatialIndexes!.Assign(value); }
    }
    private BicepList<SpatialSpec>? _spatialIndexes;

    /// <summary>
    /// Creates a new CosmosDBIndexingPolicy.
    /// </summary>
    public CosmosDBIndexingPolicy()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CosmosDBIndexingPolicy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _isAutomatic = DefineProperty<bool>("IsAutomatic", ["automatic"]);
        _indexingMode = DefineProperty<CosmosDBIndexingMode>("IndexingMode", ["indexingMode"]);
        _includedPaths = DefineListProperty<CosmosDBIncludedPath>("IncludedPaths", ["includedPaths"]);
        _excludedPaths = DefineListProperty<CosmosDBExcludedPath>("ExcludedPaths", ["excludedPaths"]);
        _compositeIndexes = DefineListProperty<BicepList<CosmosDBCompositePath>>("CompositeIndexes", ["compositeIndexes"]);
        _spatialIndexes = DefineListProperty<SpatialSpec>("SpatialIndexes", ["spatialIndexes"]);
    }
}
