// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// The paths that are included in indexing.
/// </summary>
public partial class CosmosDBIncludedPath : ProvisionableConstruct
{
    /// <summary>
    /// The path for which the indexing behavior applies to. Index paths
    /// typically start with root and end with wildcard (/path/*).
    /// </summary>
    public BicepValue<string> Path 
    {
        get { Initialize(); return _path!; }
        set { Initialize(); _path!.Assign(value); }
    }
    private BicepValue<string>? _path;

    /// <summary>
    /// List of indexes for this path.
    /// </summary>
    public BicepList<CosmosDBPathIndexes> Indexes 
    {
        get { Initialize(); return _indexes!; }
        set { Initialize(); _indexes!.Assign(value); }
    }
    private BicepList<CosmosDBPathIndexes>? _indexes;

    /// <summary>
    /// Creates a new CosmosDBIncludedPath.
    /// </summary>
    public CosmosDBIncludedPath()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CosmosDBIncludedPath.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _path = DefineProperty<string>("Path", ["path"]);
        _indexes = DefineListProperty<CosmosDBPathIndexes>("Indexes", ["indexes"]);
    }
}
