// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// The failover policy for a given region of a database account.
/// </summary>
public partial class CosmosDBFailoverPolicy : ProvisionableConstruct
{
    /// <summary>
    /// The unique identifier of the region in which the database account
    /// replicates to. Example: &lt;accountName&gt;-&lt;locationName&gt;.
    /// </summary>
    public BicepValue<string> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<string>? _id;

    /// <summary>
    /// The name of the region in which the database account exists.
    /// </summary>
    public BicepValue<AzureLocation> LocationName 
    {
        get { Initialize(); return _locationName!; }
        set { Initialize(); _locationName!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _locationName;

    /// <summary>
    /// The failover priority of the region. A failover priority of 0 indicates
    /// a write region. The maximum value for a failover priority = (total
    /// number of regions - 1). Failover priority values must be unique for
    /// each of the regions in which the database account exists.
    /// </summary>
    public BicepValue<int> FailoverPriority 
    {
        get { Initialize(); return _failoverPriority!; }
        set { Initialize(); _failoverPriority!.Assign(value); }
    }
    private BicepValue<int>? _failoverPriority;

    /// <summary>
    /// Creates a new CosmosDBFailoverPolicy.
    /// </summary>
    public CosmosDBFailoverPolicy()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CosmosDBFailoverPolicy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _id = DefineProperty<string>("Id", ["id"], isOutput: true);
        _locationName = DefineProperty<AzureLocation>("LocationName", ["locationName"]);
        _failoverPriority = DefineProperty<int>("FailoverPriority", ["failoverPriority"]);
    }
}
