// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// The CosmosDBExcludedPath.
/// </summary>
public partial class CosmosDBExcludedPath : ProvisionableConstruct
{
    /// <summary>
    /// The path for which the indexing behavior applies to. Index paths
    /// typically start with root and end with wildcard (/path/*).
    /// </summary>
    public BicepValue<string> Path 
    {
        get { Initialize(); return _path!; }
        set { Initialize(); _path!.Assign(value); }
    }
    private BicepValue<string>? _path;

    /// <summary>
    /// Creates a new CosmosDBExcludedPath.
    /// </summary>
    public CosmosDBExcludedPath()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CosmosDBExcludedPath.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _path = DefineProperty<string>("Path", ["path"]);
    }
}
