// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// CreateUpdateOptions are a list of key-value pairs that describe the
/// resource. Supported keys are &quot;If-Match&quot;,
/// &quot;If-None-Match&quot;, &quot;Session-Token&quot; and
/// &quot;Throughput&quot;.
/// </summary>
public partial class CosmosDBCreateUpdateConfig : ProvisionableConstruct
{
    /// <summary>
    /// Request Units per second. For example, &quot;throughput&quot;: 10000.
    /// </summary>
    public BicepValue<int> Throughput 
    {
        get { Initialize(); return _throughput!; }
        set { Initialize(); _throughput!.Assign(value); }
    }
    private BicepValue<int>? _throughput;

    /// <summary>
    /// Represents maximum throughput, the resource can scale up to.
    /// </summary>
    public BicepValue<int> AutoscaleMaxThroughput 
    {
        get { Initialize(); return _autoscaleMaxThroughput!; }
        set { Initialize(); _autoscaleMaxThroughput!.Assign(value); }
    }
    private BicepValue<int>? _autoscaleMaxThroughput;

    /// <summary>
    /// Creates a new CosmosDBCreateUpdateConfig.
    /// </summary>
    public CosmosDBCreateUpdateConfig()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CosmosDBCreateUpdateConfig.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _throughput = DefineProperty<int>("Throughput", ["throughput"]);
        _autoscaleMaxThroughput = DefineProperty<int>("AutoscaleMaxThroughput", ["autoscaleSettings", "maxThroughput"]);
    }
}
