// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// The configuration of the partition key to be used for partitioning data
/// into multiple partitions.
/// </summary>
public partial class CosmosDBContainerPartitionKey : ProvisionableConstruct
{
    /// <summary>
    /// List of paths using which data within the container can be partitioned.
    /// </summary>
    public BicepList<string> Paths 
    {
        get { Initialize(); return _paths!; }
        set { Initialize(); _paths!.Assign(value); }
    }
    private BicepList<string>? _paths;

    /// <summary>
    /// Indicates the kind of algorithm used for partitioning. For MultiHash,
    /// multiple partition keys (upto three maximum) are supported for
    /// container create.
    /// </summary>
    public BicepValue<CosmosDBPartitionKind> Kind 
    {
        get { Initialize(); return _kind!; }
        set { Initialize(); _kind!.Assign(value); }
    }
    private BicepValue<CosmosDBPartitionKind>? _kind;

    /// <summary>
    /// Indicates the version of the partition key definition.
    /// </summary>
    public BicepValue<int> Version 
    {
        get { Initialize(); return _version!; }
        set { Initialize(); _version!.Assign(value); }
    }
    private BicepValue<int>? _version;

    /// <summary>
    /// Indicates if the container is using a system generated partition key.
    /// </summary>
    public BicepValue<bool> IsSystemKey 
    {
        get { Initialize(); return _isSystemKey!; }
    }
    private BicepValue<bool>? _isSystemKey;

    /// <summary>
    /// Creates a new CosmosDBContainerPartitionKey.
    /// </summary>
    public CosmosDBContainerPartitionKey()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// CosmosDBContainerPartitionKey.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _paths = DefineListProperty<string>("Paths", ["paths"]);
        _kind = DefineProperty<CosmosDBPartitionKind>("Kind", ["kind"]);
        _version = DefineProperty<int>("Version", ["version"]);
        _isSystemKey = DefineProperty<bool>("IsSystemKey", ["systemKey"], isOutput: true);
    }
}
