// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// The CosmosDBCompositePath.
/// </summary>
public partial class CosmosDBCompositePath : ProvisionableConstruct
{
    /// <summary>
    /// The path for which the indexing behavior applies to. Index paths
    /// typically start with root and end with wildcard (/path/*).
    /// </summary>
    public BicepValue<string> Path 
    {
        get { Initialize(); return _path!; }
        set { Initialize(); _path!.Assign(value); }
    }
    private BicepValue<string>? _path;

    /// <summary>
    /// Sort order for composite paths.
    /// </summary>
    public BicepValue<CompositePathSortOrder> Order 
    {
        get { Initialize(); return _order!; }
        set { Initialize(); _order!.Assign(value); }
    }
    private BicepValue<CompositePathSortOrder>? _order;

    /// <summary>
    /// Creates a new CosmosDBCompositePath.
    /// </summary>
    public CosmosDBCompositePath()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CosmosDBCompositePath.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _path = DefineProperty<string>("Path", ["path"]);
        _order = DefineProperty<CompositePathSortOrder>("Order", ["order"]);
    }
}
