// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Cosmos DB client encryption policy.
/// </summary>
public partial class CosmosDBClientEncryptionPolicy : ProvisionableConstruct
{
    /// <summary>
    /// Paths of the item that need encryption along with path-specific
    /// settings.
    /// </summary>
    public BicepList<CosmosDBClientEncryptionIncludedPath> IncludedPaths 
    {
        get { Initialize(); return _includedPaths!; }
        set { Initialize(); _includedPaths!.Assign(value); }
    }
    private BicepList<CosmosDBClientEncryptionIncludedPath>? _includedPaths;

    /// <summary>
    /// Version of the client encryption policy definition. Supported versions
    /// are 1 and 2. Version 2 supports id and partition key path encryption.
    /// </summary>
    public BicepValue<int> PolicyFormatVersion 
    {
        get { Initialize(); return _policyFormatVersion!; }
        set { Initialize(); _policyFormatVersion!.Assign(value); }
    }
    private BicepValue<int>? _policyFormatVersion;

    /// <summary>
    /// Creates a new CosmosDBClientEncryptionPolicy.
    /// </summary>
    public CosmosDBClientEncryptionPolicy()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// CosmosDBClientEncryptionPolicy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _includedPaths = DefineListProperty<CosmosDBClientEncryptionIncludedPath>("IncludedPaths", ["includedPaths"]);
        _policyFormatVersion = DefineProperty<int>("PolicyFormatVersion", ["policyFormatVersion"]);
    }
}
