// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// .
/// </summary>
public partial class CosmosDBClientEncryptionIncludedPath : ProvisionableConstruct
{
    /// <summary>
    /// Path that needs to be encrypted.
    /// </summary>
    public BicepValue<string> Path 
    {
        get { Initialize(); return _path!; }
        set { Initialize(); _path!.Assign(value); }
    }
    private BicepValue<string>? _path;

    /// <summary>
    /// The identifier of the Client Encryption Key to be used to encrypt the
    /// path.
    /// </summary>
    public BicepValue<string> ClientEncryptionKeyId 
    {
        get { Initialize(); return _clientEncryptionKeyId!; }
        set { Initialize(); _clientEncryptionKeyId!.Assign(value); }
    }
    private BicepValue<string>? _clientEncryptionKeyId;

    /// <summary>
    /// The type of encryption to be performed. Eg - Deterministic, Randomized.
    /// </summary>
    public BicepValue<string> EncryptionType 
    {
        get { Initialize(); return _encryptionType!; }
        set { Initialize(); _encryptionType!.Assign(value); }
    }
    private BicepValue<string>? _encryptionType;

    /// <summary>
    /// The encryption algorithm which will be used. Eg -
    /// AEAD_AES_256_CBC_HMAC_SHA256.
    /// </summary>
    public BicepValue<string> EncryptionAlgorithm 
    {
        get { Initialize(); return _encryptionAlgorithm!; }
        set { Initialize(); _encryptionAlgorithm!.Assign(value); }
    }
    private BicepValue<string>? _encryptionAlgorithm;

    /// <summary>
    /// Creates a new CosmosDBClientEncryptionIncludedPath.
    /// </summary>
    public CosmosDBClientEncryptionIncludedPath()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// CosmosDBClientEncryptionIncludedPath.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _path = DefineProperty<string>("Path", ["path"]);
        _clientEncryptionKeyId = DefineProperty<string>("ClientEncryptionKeyId", ["clientEncryptionKeyId"]);
        _encryptionType = DefineProperty<string>("EncryptionType", ["encryptionType"]);
        _encryptionAlgorithm = DefineProperty<string>("EncryptionAlgorithm", ["encryptionAlgorithm"]);
    }
}
