// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Parameters to indicate the information about the restore.
/// </summary>
public partial class CosmosDBAccountRestoreParameters : ProvisionableConstruct
{
    /// <summary>
    /// Describes the mode of the restore.
    /// </summary>
    public BicepValue<CosmosDBAccountRestoreMode> RestoreMode 
    {
        get { Initialize(); return _restoreMode!; }
        set { Initialize(); _restoreMode!.Assign(value); }
    }
    private BicepValue<CosmosDBAccountRestoreMode>? _restoreMode;

    /// <summary>
    /// List of specific databases available for restore.
    /// </summary>
    public BicepList<DatabaseRestoreResourceInfo> DatabasesToRestore 
    {
        get { Initialize(); return _databasesToRestore!; }
        set { Initialize(); _databasesToRestore!.Assign(value); }
    }
    private BicepList<DatabaseRestoreResourceInfo>? _databasesToRestore;

    /// <summary>
    /// List of specific gremlin databases available for restore.
    /// </summary>
    public BicepList<GremlinDatabaseRestoreResourceInfo> GremlinDatabasesToRestore 
    {
        get { Initialize(); return _gremlinDatabasesToRestore!; }
        set { Initialize(); _gremlinDatabasesToRestore!.Assign(value); }
    }
    private BicepList<GremlinDatabaseRestoreResourceInfo>? _gremlinDatabasesToRestore;

    /// <summary>
    /// List of specific tables available for restore.
    /// </summary>
    public BicepList<string> TablesToRestore 
    {
        get { Initialize(); return _tablesToRestore!; }
        set { Initialize(); _tablesToRestore!.Assign(value); }
    }
    private BicepList<string>? _tablesToRestore;

    /// <summary>
    /// The source backup location for restore.
    /// </summary>
    public BicepValue<string> SourceBackupLocation 
    {
        get { Initialize(); return _sourceBackupLocation!; }
        set { Initialize(); _sourceBackupLocation!.Assign(value); }
    }
    private BicepValue<string>? _sourceBackupLocation;

    /// <summary>
    /// The id of the restorable database account from which the restore has to
    /// be initiated. For example:
    /// /subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}.
    /// </summary>
    public BicepValue<string> RestoreSource 
    {
        get { Initialize(); return _restoreSource!; }
        set { Initialize(); _restoreSource!.Assign(value); }
    }
    private BicepValue<string>? _restoreSource;

    /// <summary>
    /// Time to which the account has to be restored (ISO-8601 format).
    /// </summary>
    public BicepValue<DateTimeOffset> RestoreTimestampInUtc 
    {
        get { Initialize(); return _restoreTimestampInUtc!; }
        set { Initialize(); _restoreTimestampInUtc!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _restoreTimestampInUtc;

    /// <summary>
    /// Specifies whether the restored account will have Time-To-Live disabled
    /// upon the successful restore.
    /// </summary>
    public BicepValue<bool> IsRestoreWithTtlDisabled 
    {
        get { Initialize(); return _isRestoreWithTtlDisabled!; }
        set { Initialize(); _isRestoreWithTtlDisabled!.Assign(value); }
    }
    private BicepValue<bool>? _isRestoreWithTtlDisabled;

    /// <summary>
    /// Creates a new CosmosDBAccountRestoreParameters.
    /// </summary>
    public CosmosDBAccountRestoreParameters()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// CosmosDBAccountRestoreParameters.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _restoreMode = DefineProperty<CosmosDBAccountRestoreMode>("RestoreMode", ["restoreMode"]);
        _databasesToRestore = DefineListProperty<DatabaseRestoreResourceInfo>("DatabasesToRestore", ["databasesToRestore"]);
        _gremlinDatabasesToRestore = DefineListProperty<GremlinDatabaseRestoreResourceInfo>("GremlinDatabasesToRestore", ["gremlinDatabasesToRestore"]);
        _tablesToRestore = DefineListProperty<string>("TablesToRestore", ["tablesToRestore"]);
        _sourceBackupLocation = DefineProperty<string>("SourceBackupLocation", ["sourceBackupLocation"]);
        _restoreSource = DefineProperty<string>("RestoreSource", ["restoreSource"]);
        _restoreTimestampInUtc = DefineProperty<DateTimeOffset>("RestoreTimestampInUtc", ["restoreTimestampInUtc"]);
        _isRestoreWithTtlDisabled = DefineProperty<bool>("IsRestoreWithTtlDisabled", ["restoreWithTtlDisabled"]);
    }
}
