// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// A region in which the Azure Cosmos DB database account is deployed.
/// </summary>
public partial class CosmosDBAccountLocation : ProvisionableConstruct
{
    /// <summary>
    /// The unique identifier of the region within the database account.
    /// Example: &lt;accountName&gt;-&lt;locationName&gt;.
    /// </summary>
    public BicepValue<string> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<string>? _id;

    /// <summary>
    /// The name of the region.
    /// </summary>
    public BicepValue<AzureLocation> LocationName 
    {
        get { Initialize(); return _locationName!; }
        set { Initialize(); _locationName!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _locationName;

    /// <summary>
    /// The connection endpoint for the specific region. Example:
    /// https://&lt;accountName&gt;-&lt;locationName&gt;.documents.azure.com:443/.
    /// </summary>
    public BicepValue<string> DocumentEndpoint 
    {
        get { Initialize(); return _documentEndpoint!; }
    }
    private BicepValue<string>? _documentEndpoint;

    /// <summary>
    /// The status of the Cosmos DB account at the time the operation was
    /// called. The status can be one of following. &apos;Creating&apos; – the
    /// Cosmos DB account is being created. When an account is in Creating
    /// state, only properties that are specified as input for the Create
    /// Cosmos DB account operation are returned. &apos;Succeeded&apos; – the
    /// Cosmos DB account is active for use. &apos;Updating&apos; – the Cosmos
    /// DB account is being updated. &apos;Deleting&apos; – the Cosmos DB
    /// account is being deleted. &apos;Failed&apos; – the Cosmos DB account
    /// failed creation. &apos;DeletionFailed&apos; – the Cosmos DB account
    /// deletion failed.
    /// </summary>
    public BicepValue<string> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<string>? _provisioningState;

    /// <summary>
    /// The failover priority of the region. A failover priority of 0 indicates
    /// a write region. The maximum value for a failover priority = (total
    /// number of regions - 1). Failover priority values must be unique for
    /// each of the regions in which the database account exists.
    /// </summary>
    public BicepValue<int> FailoverPriority 
    {
        get { Initialize(); return _failoverPriority!; }
        set { Initialize(); _failoverPriority!.Assign(value); }
    }
    private BicepValue<int>? _failoverPriority;

    /// <summary>
    /// Flag to indicate whether or not this region is an AvailabilityZone
    /// region.
    /// </summary>
    public BicepValue<bool> IsZoneRedundant 
    {
        get { Initialize(); return _isZoneRedundant!; }
        set { Initialize(); _isZoneRedundant!.Assign(value); }
    }
    private BicepValue<bool>? _isZoneRedundant;

    /// <summary>
    /// Creates a new CosmosDBAccountLocation.
    /// </summary>
    public CosmosDBAccountLocation()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CosmosDBAccountLocation.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _id = DefineProperty<string>("Id", ["id"], isOutput: true);
        _locationName = DefineProperty<AzureLocation>("LocationName", ["locationName"]);
        _documentEndpoint = DefineProperty<string>("DocumentEndpoint", ["documentEndpoint"], isOutput: true);
        _provisioningState = DefineProperty<string>("ProvisioningState", ["provisioningState"], isOutput: true);
        _failoverPriority = DefineProperty<int>("FailoverPriority", ["failoverPriority"]);
        _isZoneRedundant = DefineProperty<bool>("IsZoneRedundant", ["isZoneRedundant"]);
    }
}
