// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// The CORS policy for the Cosmos DB database account.
/// </summary>
public partial class CosmosDBAccountCorsPolicy : ProvisionableConstruct
{
    /// <summary>
    /// The origin domains that are permitted to make a request against the
    /// service via CORS.
    /// </summary>
    public BicepValue<string> AllowedOrigins 
    {
        get { Initialize(); return _allowedOrigins!; }
        set { Initialize(); _allowedOrigins!.Assign(value); }
    }
    private BicepValue<string>? _allowedOrigins;

    /// <summary>
    /// The methods (HTTP request verbs) that the origin domain may use for a
    /// CORS request.
    /// </summary>
    public BicepValue<string> AllowedMethods 
    {
        get { Initialize(); return _allowedMethods!; }
        set { Initialize(); _allowedMethods!.Assign(value); }
    }
    private BicepValue<string>? _allowedMethods;

    /// <summary>
    /// The request headers that the origin domain may specify on the CORS
    /// request.
    /// </summary>
    public BicepValue<string> AllowedHeaders 
    {
        get { Initialize(); return _allowedHeaders!; }
        set { Initialize(); _allowedHeaders!.Assign(value); }
    }
    private BicepValue<string>? _allowedHeaders;

    /// <summary>
    /// The response headers that may be sent in the response to the CORS
    /// request and exposed by the browser to the request issuer.
    /// </summary>
    public BicepValue<string> ExposedHeaders 
    {
        get { Initialize(); return _exposedHeaders!; }
        set { Initialize(); _exposedHeaders!.Assign(value); }
    }
    private BicepValue<string>? _exposedHeaders;

    /// <summary>
    /// The maximum amount time that a browser should cache the preflight
    /// OPTIONS request.
    /// </summary>
    public BicepValue<long> MaxAgeInSeconds 
    {
        get { Initialize(); return _maxAgeInSeconds!; }
        set { Initialize(); _maxAgeInSeconds!.Assign(value); }
    }
    private BicepValue<long>? _maxAgeInSeconds;

    /// <summary>
    /// Creates a new CosmosDBAccountCorsPolicy.
    /// </summary>
    public CosmosDBAccountCorsPolicy()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CosmosDBAccountCorsPolicy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _allowedOrigins = DefineProperty<string>("AllowedOrigins", ["allowedOrigins"]);
        _allowedMethods = DefineProperty<string>("AllowedMethods", ["allowedMethods"]);
        _allowedHeaders = DefineProperty<string>("AllowedHeaders", ["allowedHeaders"]);
        _exposedHeaders = DefineProperty<string>("ExposedHeaders", ["exposedHeaders"]);
        _maxAgeInSeconds = DefineProperty<long>("MaxAgeInSeconds", ["maxAgeInSeconds"]);
    }
}
