// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// The object representing continuous mode backup policy.
/// </summary>
public partial class ContinuousModeBackupPolicy : CosmosDBAccountBackupPolicy
{
    /// <summary>
    /// Enum to indicate type of Continuos backup mode.
    /// </summary>
    public BicepValue<ContinuousTier> ContinuousModeTier 
    {
        get { Initialize(); return _continuousModeTier!; }
        set { Initialize(); _continuousModeTier!.Assign(value); }
    }
    private BicepValue<ContinuousTier>? _continuousModeTier;

    /// <summary>
    /// Creates a new ContinuousModeBackupPolicy.
    /// </summary>
    public ContinuousModeBackupPolicy() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContinuousModeBackupPolicy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("type", ["type"], defaultValue: "Continuous");
        _continuousModeTier = DefineProperty<ContinuousTier>("ContinuousModeTier", ["continuousModeProperties", "tier"]);
    }
}
