// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// The consistency policy for the Cosmos DB database account.
/// </summary>
public partial class ConsistencyPolicy : ProvisionableConstruct
{
    /// <summary>
    /// The default consistency level and configuration settings of the Cosmos
    /// DB account.
    /// </summary>
    public BicepValue<DefaultConsistencyLevel> DefaultConsistencyLevel 
    {
        get { Initialize(); return _defaultConsistencyLevel!; }
        set { Initialize(); _defaultConsistencyLevel!.Assign(value); }
    }
    private BicepValue<DefaultConsistencyLevel>? _defaultConsistencyLevel;

    /// <summary>
    /// When used with the Bounded Staleness consistency level, this value
    /// represents the number of stale requests tolerated. Accepted range for
    /// this value is 1 – 2,147,483,647. Required when
    /// defaultConsistencyPolicy is set to &apos;BoundedStaleness&apos;.
    /// </summary>
    public BicepValue<long> MaxStalenessPrefix 
    {
        get { Initialize(); return _maxStalenessPrefix!; }
        set { Initialize(); _maxStalenessPrefix!.Assign(value); }
    }
    private BicepValue<long>? _maxStalenessPrefix;

    /// <summary>
    /// When used with the Bounded Staleness consistency level, this value
    /// represents the time amount of staleness (in seconds) tolerated.
    /// Accepted range for this value is 5 - 86400. Required when
    /// defaultConsistencyPolicy is set to &apos;BoundedStaleness&apos;.
    /// </summary>
    public BicepValue<int> MaxIntervalInSeconds 
    {
        get { Initialize(); return _maxIntervalInSeconds!; }
        set { Initialize(); _maxIntervalInSeconds!.Assign(value); }
    }
    private BicepValue<int>? _maxIntervalInSeconds;

    /// <summary>
    /// Creates a new ConsistencyPolicy.
    /// </summary>
    public ConsistencyPolicy()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ConsistencyPolicy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _defaultConsistencyLevel = DefineProperty<DefaultConsistencyLevel>("DefaultConsistencyLevel", ["defaultConsistencyLevel"]);
        _maxStalenessPrefix = DefineProperty<long>("MaxStalenessPrefix", ["maxStalenessPrefix"]);
        _maxIntervalInSeconds = DefineProperty<int>("MaxIntervalInSeconds", ["maxIntervalInSeconds"]);
    }
}
