// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// The conflict resolution policy for the container.
/// </summary>
public partial class ConflictResolutionPolicy : ProvisionableConstruct
{
    /// <summary>
    /// Indicates the conflict resolution mode.
    /// </summary>
    public BicepValue<ConflictResolutionMode> Mode 
    {
        get { Initialize(); return _mode!; }
        set { Initialize(); _mode!.Assign(value); }
    }
    private BicepValue<ConflictResolutionMode>? _mode;

    /// <summary>
    /// The conflict resolution path in the case of LastWriterWins mode.
    /// </summary>
    public BicepValue<string> ConflictResolutionPath 
    {
        get { Initialize(); return _conflictResolutionPath!; }
        set { Initialize(); _conflictResolutionPath!.Assign(value); }
    }
    private BicepValue<string>? _conflictResolutionPath;

    /// <summary>
    /// The procedure to resolve conflicts in the case of custom mode.
    /// </summary>
    public BicepValue<string> ConflictResolutionProcedure 
    {
        get { Initialize(); return _conflictResolutionProcedure!; }
        set { Initialize(); _conflictResolutionProcedure!.Assign(value); }
    }
    private BicepValue<string>? _conflictResolutionProcedure;

    /// <summary>
    /// Creates a new ConflictResolutionPolicy.
    /// </summary>
    public ConflictResolutionPolicy()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ConflictResolutionPolicy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _mode = DefineProperty<ConflictResolutionMode>("Mode", ["mode"]);
        _conflictResolutionPath = DefineProperty<string>("ConflictResolutionPath", ["conflictResolutionPath"]);
        _conflictResolutionProcedure = DefineProperty<string>("ConflictResolutionProcedure", ["conflictResolutionProcedure"]);
    }
}
