// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// The definition of a computed property.
/// </summary>
public partial class ComputedProperty : ProvisionableConstruct
{
    /// <summary>
    /// The name of a computed property, for example - &quot;cp_lowerName&quot;.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The query that evaluates the value for computed property, for example -
    /// &quot;SELECT VALUE LOWER(c.name) FROM c&quot;.
    /// </summary>
    public BicepValue<string> Query 
    {
        get { Initialize(); return _query!; }
        set { Initialize(); _query!.Assign(value); }
    }
    private BicepValue<string>? _query;

    /// <summary>
    /// Creates a new ComputedProperty.
    /// </summary>
    public ComputedProperty()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ComputedProperty.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _query = DefineProperty<string>("Query", ["query"]);
    }
}
