// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Cosmos DB Cassandra view resource object.
/// </summary>
public partial class CassandraViewResource : ProvisionableConstruct
{
    /// <summary>
    /// Name of the Cosmos DB Cassandra view.
    /// </summary>
    public BicepValue<string> Id 
    {
        get { Initialize(); return _id!; }
        set { Initialize(); _id!.Assign(value); }
    }
    private BicepValue<string>? _id;

    /// <summary>
    /// View Definition of the Cosmos DB Cassandra view.
    /// </summary>
    public BicepValue<string> ViewDefinition 
    {
        get { Initialize(); return _viewDefinition!; }
        set { Initialize(); _viewDefinition!.Assign(value); }
    }
    private BicepValue<string>? _viewDefinition;

    /// <summary>
    /// Creates a new CassandraViewResource.
    /// </summary>
    public CassandraViewResource()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CassandraViewResource.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _id = DefineProperty<string>("Id", ["id"]);
        _viewDefinition = DefineProperty<string>("ViewDefinition", ["viewDefinition"]);
    }
}
