// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Cosmos DB Cassandra table resource object.
/// </summary>
public partial class CassandraTableResourceInfo : ProvisionableConstruct
{
    /// <summary>
    /// Name of the Cosmos DB Cassandra table.
    /// </summary>
    public BicepValue<string> TableName 
    {
        get { Initialize(); return _tableName!; }
        set { Initialize(); _tableName!.Assign(value); }
    }
    private BicepValue<string>? _tableName;

    /// <summary>
    /// Time to live of the Cosmos DB Cassandra table.
    /// </summary>
    public BicepValue<int> DefaultTtl 
    {
        get { Initialize(); return _defaultTtl!; }
        set { Initialize(); _defaultTtl!.Assign(value); }
    }
    private BicepValue<int>? _defaultTtl;

    /// <summary>
    /// Schema of the Cosmos DB Cassandra table.
    /// </summary>
    public CassandraSchema Schema 
    {
        get { Initialize(); return _schema!; }
        set { Initialize(); AssignOrReplace(ref _schema, value); }
    }
    private CassandraSchema? _schema;

    /// <summary>
    /// Analytical TTL.
    /// </summary>
    public BicepValue<int> AnalyticalStorageTtl 
    {
        get { Initialize(); return _analyticalStorageTtl!; }
        set { Initialize(); _analyticalStorageTtl!.Assign(value); }
    }
    private BicepValue<int>? _analyticalStorageTtl;

    /// <summary>
    /// Creates a new CassandraTableResourceInfo.
    /// </summary>
    public CassandraTableResourceInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CassandraTableResourceInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _tableName = DefineProperty<string>("TableName", ["id"]);
        _defaultTtl = DefineProperty<int>("DefaultTtl", ["defaultTtl"]);
        _schema = DefineModelProperty<CassandraSchema>("Schema", ["schema"]);
        _analyticalStorageTtl = DefineProperty<int>("AnalyticalStorageTtl", ["analyticalStorageTtl"]);
    }
}
