// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Cosmos DB Cassandra table schema.
/// </summary>
public partial class CassandraSchema : ProvisionableConstruct
{
    /// <summary>
    /// List of Cassandra table columns.
    /// </summary>
    public BicepList<CassandraColumn> Columns 
    {
        get { Initialize(); return _columns!; }
        set { Initialize(); _columns!.Assign(value); }
    }
    private BicepList<CassandraColumn>? _columns;

    /// <summary>
    /// List of partition key.
    /// </summary>
    public BicepList<CassandraPartitionKey> PartitionKeys 
    {
        get { Initialize(); return _partitionKeys!; }
        set { Initialize(); _partitionKeys!.Assign(value); }
    }
    private BicepList<CassandraPartitionKey>? _partitionKeys;

    /// <summary>
    /// List of cluster key.
    /// </summary>
    public BicepList<CassandraClusterKey> ClusterKeys 
    {
        get { Initialize(); return _clusterKeys!; }
        set { Initialize(); _clusterKeys!.Assign(value); }
    }
    private BicepList<CassandraClusterKey>? _clusterKeys;

    /// <summary>
    /// Creates a new CassandraSchema.
    /// </summary>
    public CassandraSchema()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CassandraSchema.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _columns = DefineListProperty<CassandraColumn>("Columns", ["columns"]);
        _partitionKeys = DefineListProperty<CassandraPartitionKey>("PartitionKeys", ["partitionKeys"]);
        _clusterKeys = DefineListProperty<CassandraClusterKey>("ClusterKeys", ["clusterKeys"]);
    }
}
