// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Cosmos DB Cassandra table partition key.
/// </summary>
public partial class CassandraPartitionKey : ProvisionableConstruct
{
    /// <summary>
    /// Name of the Cosmos DB Cassandra table partition key.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Creates a new CassandraPartitionKey.
    /// </summary>
    public CassandraPartitionKey()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CassandraPartitionKey.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
    }
}
