// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// The CassandraError.
/// </summary>
public partial class CassandraError : ProvisionableConstruct
{
    /// <summary>
    /// The code of error that occurred.
    /// </summary>
    public BicepValue<string> Code 
    {
        get { Initialize(); return _code!; }
        set { Initialize(); _code!.Assign(value); }
    }
    private BicepValue<string>? _code;

    /// <summary>
    /// The message of the error.
    /// </summary>
    public BicepValue<string> Message 
    {
        get { Initialize(); return _message!; }
        set { Initialize(); _message!.Assign(value); }
    }
    private BicepValue<string>? _message;

    /// <summary>
    /// The target resource of the error.
    /// </summary>
    public BicepValue<string> Target 
    {
        get { Initialize(); return _target!; }
        set { Initialize(); _target!.Assign(value); }
    }
    private BicepValue<string>? _target;

    /// <summary>
    /// Additional information about the error.
    /// </summary>
    public BicepValue<string> AdditionalErrorInfo 
    {
        get { Initialize(); return _additionalErrorInfo!; }
        set { Initialize(); _additionalErrorInfo!.Assign(value); }
    }
    private BicepValue<string>? _additionalErrorInfo;

    /// <summary>
    /// Creates a new CassandraError.
    /// </summary>
    public CassandraError()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CassandraError.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _code = DefineProperty<string>("Code", ["code"]);
        _message = DefineProperty<string>("Message", ["message"]);
        _target = DefineProperty<string>("Target", ["target"]);
        _additionalErrorInfo = DefineProperty<string>("AdditionalErrorInfo", ["additionalErrorInfo"]);
    }
}
